<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Prescription - {{ $prescription->prescription_number }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
        }
        .header {
            margin-bottom: 30px;
        border-bottom: 2px solid #000;
            padding-bottom: 20px;
        }
        .letterhead {
            max-width: 100%;
            margin-bottom: 20px;
        }
        .doctor-info {
            margin-top: 20px;
        }
        .patient-info {
            margin: 20px 0;
            padding: 15px;
            background-color: #f5f5f5;
        }
        .vitals {
            margin: 20px 0;
        }
        .vitals table {
            width: 100%;
            border-collapse: collapse;
        }
        .vitals td {
            padding: 5px;
            border: 1px solid #ddd;
        }
        .prescription-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        .prescription-table th,
        .prescription-table td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
        }
        .prescription-table th {
            background-color: #f0f0f0;
        }
        .footer {
            margin-top: 40px;
            text-align: right;
        }
        .signature {
            margin-top: 60px;
        }
        .stamp {
            position: absolute;
            right: 20px;
            bottom: 100px;
            max-width: 150px;
        }
    </style>
</head>
<body>
    @if($letterhead)
        <img src="{{ $letterhead }}" alt="Letterhead" class="letterhead">
    @else
        <div class="header">
            <h1>{{ $doctor->full_name }}</h1>
            <p>{{ $doctor->qualification }}</p>
            <p>Practice Number: {{ $doctor->practice_number }}</p>
        </div>
    @endif

    <div class="doctor-info">
        <p><strong>{{ $doctor->full_name }}</strong></p>
        <p>{{ $doctor->qualification }}</p>
        <p>Practice Number: {{ $doctor->practice_number }}</p>
        <p>{{ $doctor->phone }}</p>
    </div>

    <div class="patient-info">
        <h3>Patient Information</h3>
        <p><strong>Patient ID:</strong> {{ $patient->patient_id }}</p>
        <p><strong>Name:</strong> {{ $patient->full_name }}</p>
        <p><strong>Age:</strong> {{ $patient->date_of_birth ? \Carbon\Carbon::parse($patient->date_of_birth)->age : 'N/A' }}</p>
        <p><strong>DOB:</strong> {{ $patient->date_of_birth ? \Carbon\Carbon::parse($patient->date_of_birth)->format('m/d/Y') : 'N/A' }}</p>
        <p><strong>Gender:</strong> {{ $patient->gender ?? 'N/A' }}</p>
        <p><strong>Payment Mode:</strong> {{ $patient->payment_mode }}</p>
        @if($patient->payment_mode === 'Medical Aid Payment')
            <p><strong>Medical Aid:</strong> {{ $patient->medical_aid_number ?? 'N/A' }}</p>
            <p><strong>Main Member:</strong> {{ $patient->main_member ?? 'N/A' }}</p>
        @endif
    </div>

    @if($vitals)
    <div class="vitals">
        <h3>Vitals</h3>
        <table>
            <tr>
                <td><strong>Blood Pressure:</strong> {{ $vitals->blood_pressure ?? 'N/A' }} mmHg</td>
                <td><strong>Pulse Rate:</strong> {{ $vitals->pulse_rate ?? 'N/A' }} bpm</td>
            </tr>
            <tr>
                <td><strong>Temperature:</strong> {{ $vitals->temperature ?? 'N/A' }} °C</td>
                <td><strong>RBS:</strong> {{ $vitals->rbs ?? 'N/A' }} %</td>
            </tr>
        </table>
    </div>
    @endif

    <div>
        <h3>Diagnosis: {{ $prescription->diagnosis ?? 'N/A' }}</h3>
    </div>

    <div>
        <h3>Prescription</h3>
        <table class="prescription-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Medicine Name</th>
                    <th>Dosage</th>
                    <th>Frequency</th>
                    <th>Instructions</th>
                    <th>Duration</th>
                </tr>
            </thead>
            <tbody>
                @foreach($items as $item)
                <tr>
                    <td>{{ $item->item_number }}</td>
                    <td>{{ $item->medicine_name }}</td>
                    <td>{{ $item->dosage }}</td>
                    <td>{{ $item->frequency }}</td>
                    <td>{{ $item->instructions ?? 'N/A' }}</td>
                    <td>{{ $item->duration }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    @if($prescription->additional_prescription_details)
    <div>
        <h3>Additional Prescription Details</h3>
        <p>{{ $prescription->additional_prescription_details }}</p>
    </div>
    @endif

    @if($stamp)
        <img src="{{ $stamp }}" alt="Stamp" class="stamp">
    @endif

    <div class="footer">
        <div class="signature">
            @if($signature)
                <img src="{{ $signature }}" alt="Signature" style="max-width: 200px;">
            @endif
            <p><strong>{{ $doctor->full_name }}</strong></p>
            <p>{{ $doctor->qualification }}</p>
        </div>
        <p>Date: {{ $prescription->created_at->format('l, F d, Y') }}</p>
    </div>
</body>
</html>

